<?php
session_start();


if (empty($_SESSION['user']) || strtolower($_SESSION['user']['role']) !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}

require_once __DIR__ . '/../config/db.php';
require_once 'includes/header.php';
require_once 'includes/admin_nav.php';

?>

<div class="container-fluid">
  <div class="row">
    <!-- Sidebar -->
    <nav class="col-md-2 d-none d-md-block bg-light sidebar vh-100 shadow-sm">
      <div class="position-sticky pt-3">
        <h5 class="px-3">Admin Panel</h5>
        <ul class="nav flex-column mt-3">
          <li class="nav-item">
            <a class="nav-link active" href="admin_panel.php"><i class="bi bi-graph-up text-muted fs-5"></i> Dashboard</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="users.php"><i class="bi bi-person-fill text-muted fs-5"></i> Usuarios</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="orders.php"><i class="bi bi-cart4 text-muted fs-5"></i> Órdenes</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="products.php"><i class="bi bi-archive-fill text-muted fs-5"></i> Productos</a>
          </li>
        </ul>
      </div>
    </nav>

    <!-- Contenido principal -->
    <main class="col-md-10 ms-sm-auto px-md-4 py-4">
      <h2>Bienvenido, <?= htmlspecialchars($_SESSION['user']['name']) ?></h2>

      <?php
      // Estadísticas básicas
      $totalUsers = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
      $totalOrders = $pdo->query("SELECT COUNT(*) FROM orders")->fetchColumn();
      $totalProducts = $pdo->query("SELECT COUNT(*) FROM products")->fetchColumn();
      ?>

      <div class="row mt-4">
        <div class="col-md-4 mb-3">
          <div class="card text-center shadow-sm">
            <div class="card-body">
              <h5 class="card-title">Usuarios</h5>
              <p class="card-text display-6"><?= $totalUsers ?></p>
              <a href="users.php" class="btn btn-primary btn-sm">Ver usuarios</a>
            </div>
          </div>
        </div>
        <div class="col-md-4 mb-3">
          <div class="card text-center shadow-sm">
            <div class="card-body">
              <h5 class="card-title">Órdenes</h5>
              <p class="card-text display-6"><?= $totalOrders ?></p>
              <a href="orders.php" class="btn btn-primary btn-sm">Ver órdenes</a>
            </div>
          </div>
        </div>
        <div class="col-md-4 mb-3">
          <div class="card text-center shadow-sm">
            <div class="card-body">
              <h5 class="card-title">Productos</h5>
              <p class="card-text display-6"><?= $totalProducts ?></p>
              <a href="products.php" class="btn btn-primary btn-sm">Ver productos</a>
            </div>
          </div>
        </div>
      </div>
    </main>
  </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
