<?php
session_start();


if (empty($_SESSION['user']) || strtolower($_SESSION['user']['role']) !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';

$product_id = $_GET['id'] ?? null;
if (!$product_id) {
    echo "<p>Producto no encontrado.</p>";
    exit;
}


$stmt = $pdo->prepare("SELECT * FROM products WHERE id = :id");
$stmt->execute([':id' => $product_id]);
$product = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$product) {
    echo "<p>Producto no encontrado.</p>";
    exit;
}


$categories = $pdo->query("SELECT id, name FROM categories ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);


if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name = trim($_POST['name'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $price = (float)($_POST['price'] ?? 0);
    $category_id = $_POST['category_id'] ?: null;

  
    $update = $pdo->prepare("
        UPDATE products SET
            name = :name,
            description = :description,
            price = :price,
            category_id = :category_id
        WHERE id = :id
    ");
    $update->execute([
        ':name' => $name,
        ':description' => $description,
        ':price' => $price,
        ':category_id' => $category_id,
        ':id' => $product_id
    ]);

    if (!empty($_FILES['image']['name'])) {
        $imgName = basename($_FILES['image']['name']);
        $targetDir = __DIR__ . '/../assets/img/';
        $targetFile = $targetDir . $imgName;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)) {
            $stmtImg = $pdo->prepare("INSERT INTO product_images (product_id, image) VALUES (:pid, :img)");
            $stmtImg->execute([
                ':pid' => $product_id,
                ':img' => $imgName
            ]);
        }
    }

    $_SESSION['success'] = "Producto actualizado correctamente.";
    header("Location: " . BASE_URL . "/../admin/products.php");
    exit;
}


$images = $pdo->prepare("SELECT * FROM product_images WHERE product_id = :pid ORDER BY id ASC");
$images->execute([':pid' => $product_id]);
$images = $images->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container py-4">
    <h2>Editar Producto</h2>

    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data">
        <div class="mb-3">
            <label class="form-label">Nombre</label>
            <input type="text" class="form-control" name="name" value="<?= htmlspecialchars($product['name']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Descripción</label>
            <textarea class="form-control" name="description" rows="4"><?= htmlspecialchars($product['description']) ?></textarea>
        </div>

        <div class="mb-3">
            <label class="form-label">Precio</label>
            <input type="number" step="0.01" class="form-control" name="price" value="<?= htmlspecialchars($product['price']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Categoría</label>
            <select class="form-select" name="category_id">
                <option value="">Sin categoría</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>" <?= $cat['id'] == $product['category_id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($cat['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Nueva imagen</label>
            <input type="file" class="form-control" name="image" accept="image/*">
        </div>

        <?php if (!empty($images)): ?>
            <div class="mb-3">
                <label class="form-label">Imágenes actuales</label>
                <div class="d-flex gap-2 flex-wrap">
                    <?php foreach ($images as $img): ?>
                        <div style="position:relative;">
                            <img src="<?= BASE_URL . '/assets/img/' . $img['image'] ?>" style="width:100px;height:100px;object-fit:cover;">
                            <a href="delete_image.php?id=<?= $img['id'] ?>&product_id=<?= $product_id ?>" 
                               class="btn btn-sm btn-danger" style="position:absolute;top:0;right:0;">X</a>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>

        <button type="submit" class="btn btn-primary">Guardar cambios</button>
        <a href="<?= BASE_URL ?>/../admin/products.php" class="btn btn-secondary">Volver</a>
    </form>
</div>
<?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success" id="success-alert">
        <?= $_SESSION['success']; unset($_SESSION['success']); ?>
    </div>

    <script>
        setTimeout(() => {
            const alert = document.getElementById('success-alert');
            if(alert){
                alert.style.transition = "opacity 0.5s ease";
                alert.style.opacity = '0';
                setTimeout(() => alert.remove(), 500);
            }
        }, 3000);
    </script>
<?php endif; ?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
