<?php
session_start();
if (!isset($_SESSION['user']) || strtolower($_SESSION['user']['role']) !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}

require_once __DIR__ . '/../config/db.php';


if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}


$orders = $pdo->query("
    SELECT o.id, o.user_id, u.name AS user_name, o.total, o.address, o.payment_method, o.created_at
    FROM orders o
    JOIN users u ON o.user_id = u.id
    ORDER BY o.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Órdenes - Panel Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .product-thumb { width: 50px; height: 50px; object-fit: cover; margin-right: 5px; border-radius: 5px; }
        .order-card { transition: 0.2s; }
        .order-card:hover { transform: scale(1.02); box-shadow: 0 0 15px rgba(0,0,0,0.15); }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container">
        <a class="navbar-brand" href="admin_panel.php">Panel Admin</a>
        <ul class="navbar-nav ms-auto">
            <li class="nav-item"><a class="nav-link text-white" href="users.php">Usuarios</a></li>
            <li class="nav-item"><a class="nav-link text-white" href="orders.php">Órdenes</a></li>
            <li class="nav-item"><a class="nav-link text-danger" href="../public/logout.php">Cerrar sesión</a></li>
        </ul>
    </div>
</nav>

<div class="container py-4">
    <h2>Órdenes</h2>
    <?php if(empty($orders)): ?>
        <p>No hay órdenes.</p>
    <?php else: ?>
        <div class="row row-cols-1 row-cols-md-2 g-3 mt-3">
            <?php foreach($orders as $order): ?>
                <?php
                
                    $stmtItems = $pdo->prepare("
                        SELECT oi.*, p.name AS product_name, p.image_url
                        FROM order_items oi
                        JOIN products p ON oi.product_id = p.id
                        WHERE oi.order_id = :oid
                    ");
                    $stmtItems->execute([':oid' => $order['id']]);
                    $items = $stmtItems->fetchAll(PDO::FETCH_ASSOC);
                ?>
                <div class="col">
                    <div class="card p-3 order-card h-100">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <h5>Orden #<?= $order['id'] ?></h5>
                            <small class="text-muted"><?= $order['created_at'] ?></small>
                        </div>
                        <p><strong>Usuario:</strong> <?= htmlspecialchars($order['user_name']) ?></p>
                        <p><strong>Total:</strong> $<?= number_format($order['total'],2) ?></p>
                        <p><strong>Método de pago:</strong> <?= htmlspecialchars($order['payment_method']) ?></p>
                        <p><strong>Dirección:</strong> <?= htmlspecialchars($order['address']) ?></p>

                    

                        <a href="view_order.php?id=<?= $order['id'] ?>" class="btn btn-sm btn-info">Ver detalles</a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
