<?php
session_start();
if (!isset($_SESSION['user']) || strtolower($_SESSION['user']['role']) !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}

require_once __DIR__ . '/../config/db.php';
require_once 'includes/header.php';
require_once 'includes/admin_nav.php';

$products = $pdo->query("SELECT p.*, u.name AS seller FROM products p JOIN users u ON p.user_id = u.id ORDER BY created_at DESC")->fetchAll();
?>

<div class="container">
  <h1 class="mb-4">Productos</h1>
  <table class="table table-bordered table-striped">
    <thead>
      <tr>
        <th>ID</th>
        <th>Nombre</th>
        <th>Vendedor</th>
        <th>Precio</th>
        <th>Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($products as $p): ?>
      <tr data-product-id="<?= $p['id'] ?>">
        <td><?= $p['id'] ?></td>
        <td><?= htmlspecialchars($p['name']) ?></td>
        <td><?= htmlspecialchars($p['seller']) ?></td>
        <td>$<?= number_format($p['price'],2) ?></td>
        <td>
          <a href="edit_product.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-warning">Editar</a>
          <button class="btn btn-sm btn-danger" 
                  data-product-id="<?= $p['id'] ?>" 
                  data-product-name="<?= htmlspecialchars($p['name']) ?>"
                  data-bs-toggle="modal" 
                  data-bs-target="#deleteModal">
            Eliminar
          </button>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="deleteModalLabel">Confirmar eliminación</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        ¿Estás seguro de que deseas eliminar el producto <strong id="modal-product-name"></strong>?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        <a href="/../mercadoapp/admin/admin_panel.php" id="confirm-delete-link"><button type="button" class="btn btn-danger">Eliminar</button></a>
      </div>
    </div>
  </div>
</div>

<script>
let productIdToDelete = null;
const deleteModal = document.getElementById('deleteModal');
deleteModal.addEventListener('show.bs.modal', event => {
    const button = event.relatedTarget;
    productIdToDelete = button.getAttribute('data-product-id');
    document.getElementById('modal-product-name').textContent = button.getAttribute('data-product-name');
});

document.getElementById('confirm-delete-btn').addEventListener('click', () => {
    if(!productIdToDelete) return;
    fetch('/admin/admin_delete_product.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({ id: productIdToDelete })
    })
    .then(res => res.json())
    .then(data => {
        if(data.success){
            const modalInstance = bootstrap.Modal.getInstance(deleteModal);
            modalInstance.hide();
            const row = document.querySelector(`tr[data-product-id="${productIdToDelete}"]`);
            if(row) row.remove();
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-success mt-3';
            alertDiv.textContent = data.message;
            document.querySelector('.container').prepend(alertDiv);
            setTimeout(() => alertDiv.remove(), 3000);
        } else {
            alert(data.message || 'Error al eliminar');
        }
    })
    .catch(err => console.error(err));
});
</script>

<?php require_once 'includes/footer.php'; ?>
