<?php
session_start();
if (!isset($_SESSION['user']) || strtolower($_SESSION['user']['role']) !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/admin_nav.php';


if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}


$page = max(1, (int)($_GET['page'] ?? 1));
$perPage = 10;
$offset = ($page - 1) * $perPage;


$search = trim($_GET['search'] ?? '');
$params = [];

$sql = "SELECT * FROM users WHERE 1=1";
if ($search) {
    $sql .= " AND (name ILIKE :s OR email ILIKE :s)";
    $params[':s'] = "%$search%";
}

$totalUsers = $pdo->prepare(str_replace('*', 'COUNT(*)', $sql));
$totalUsers->execute($params);
$totalUsers = $totalUsers->fetchColumn();

$sql .= " ORDER BY id ASC LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($sql);
foreach ($params as $k => $v) $stmt->bindValue($k, $v);
$stmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
  <div class="row">
    <?php include 'C:\xampp\htdocs\Mercadoapp\admin\includes\sidebar.php'; ?>

    <main class="col-md-10 ms-sm-auto px-md-4 py-4">
      <h2>Usuarios</h2>

      <form class="d-flex mb-3" method="get">
        <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" class="form-control me-2" placeholder="Buscar por nombre o email">
        <button class="btn btn-primary">Buscar</button>
      </form>

      <table class="table table-striped table-hover">
        <thead>
          <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Email</th>
            <th>Rol</th>
            <th>Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($users as $u): ?>
            <tr>
              <td><?= $u['id'] ?></td>
              <td><?= htmlspecialchars($u['name']) ?></td>
              <td><?= htmlspecialchars($u['email']) ?></td>
              <td><?= $u['role'] ?: 'usuario' ?></td>
              <td>
                <a href="edit_user.php?id=<?= $u['id'] ?>" class="btn btn-sm btn-warning">Editar</a>
                <a href="delete_user.php?id=<?= $u['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar usuario?')">Eliminar</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>

      
      <?php
      $totalPages = ceil($totalUsers / $perPage);
      if ($totalPages > 1):
      ?>
      <nav>
        <ul class="pagination">
          <?php for($i=1;$i<=$totalPages;$i++): ?>
            <li class="page-item <?= $i==$page?'active':'' ?>">
              <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
            </li>
          <?php endfor; ?>
        </ul>
      </nav>
      <?php endif; ?>
    </main>
  </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
