<?php
session_start();
if (!isset($_SESSION['user']) || strtolower($_SESSION['user']['role']) !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/includes/admin_nav.php';


if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}


$orderId = (int)($_GET['id'] ?? 0);
if (!$orderId) {
    die("Orden no especificada.");
}


$stmtOrder = $pdo->prepare("
    SELECT o.*, u.name AS user_name, u.email AS user_email
    FROM orders o
    JOIN users u ON o.user_id = u.id
    WHERE o.id = :oid
");
$stmtOrder->execute([':oid' => $orderId]);
$order = $stmtOrder->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    die("Orden no encontrada.");
}


$stmtItems = $pdo->prepare("
    SELECT oi.*, p.name AS product_name, p.image_url
    FROM order_items oi
    JOIN products p ON oi.product_id = p.id
    WHERE oi.order_id = :oid
");
$stmtItems->execute([':oid' => $orderId]);
$items = $stmtItems->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Orden #<?= $order['id'] ?> - Panel Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .product-thumb { width: 60px; height: 60px; object-fit: cover; border-radius: 5px; }
    </style>
</head>
<body>
<div class="container py-4">
    <h2>Detalles de la Orden #<?= $order['id'] ?></h2>
    <p><strong>Usuario:</strong> <?= htmlspecialchars($order['user_name']) ?> (<?= htmlspecialchars($order['user_email']) ?>)</p>
    <p><strong>Total:</strong> $<?= number_format($order['total'], 2) ?></p>
    <p><strong>Método de pago:</strong> <?= htmlspecialchars($order['payment_method']) ?></p>
    <p><strong>Dirección:</strong> <?= htmlspecialchars($order['address']) ?></p>
    <p><strong>Fecha:</strong> <?= $order['created_at'] ?></p>

    <h4 class="mt-4">Productos</h4>
    <?php if(empty($items)): ?>
        <p>No hay productos en esta orden.</p>
    <?php else: ?>
        <table class="table table-bordered table-hover mt-2">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Imagen</th>
                    <th>Cantidad</th>
                    <th>Precio unitario</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($items as $item): ?>
                    <tr>
                        <td><?= htmlspecialchars($item['product_name']) ?></td>
                        <td><img src="<?= htmlspecialchars($item['image_url'] ?: 'https://picsum.photos/seed/noimg/60/60') ?>" class="product-thumb"></td>
                        <td><?= $item['quantity'] ?></td>
                        <td>$<?= number_format($item['price'], 2) ?></td>
                        <td>$<?= number_format($item['price'] * $item['quantity'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>

    <a href="orders.php" class="btn btn-secondary mt-3">← Volver a Órdenes</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
