<?php
session_start();
require_once __DIR__ . '/../config/db.php';

$action = $_GET['action'] ?? 'add';
$id = (int)($_GET['id'] ?? 0);
$qty = max(1,(int)($_GET['quantity'] ?? 1)); // ahora lee quantity

if (!$id) { 
    header('Location: ../public/cart.php'); 
    exit; 
}

if (!isset($_SESSION['cart'])) $_SESSION['cart'] = [];

switch($action){
    case 'add':
        $stmt = $pdo->prepare("SELECT id,name,price FROM products WHERE id=:id");
        $stmt->execute([':id'=>$id]);
        $product = $stmt->fetch();
        if ($product){
            if (isset($_SESSION['cart'][$id])){
                $_SESSION['cart'][$id]['quantity'] += $qty; // suma la cantidad
            } else {
                $_SESSION['cart'][$id] = [
                    'id' => $product['id'],
                    'name' => $product['name'],
                    'price' => $product['price'],
                    'quantity' => $qty
                ];
            }
        }
        break;

    case 'remove':
        if (isset($_SESSION['cart'][$id])) unset($_SESSION['cart'][$id]);
        break;

    case 'update':
        if (isset($_SESSION['cart'][$id])) $_SESSION['cart'][$id]['quantity'] = $qty;
        break;
}

header('Location: ../public/cart.php');
exit;
