document.addEventListener('DOMContentLoaded', function () {
  console.log("App cargada correctamente 🚀");

  // Toggle Dark Mode
  const toggleBtn = document.getElementById('darkModeToggle');
  if (toggleBtn) {
    toggleBtn.addEventListener('click', function () {
      document.body.classList.toggle('dark');
      // Guardar preferencia en localStorage
      if (document.body.classList.contains('dark')) {
        localStorage.setItem('theme', 'dark');
      } else {
        localStorage.setItem('theme', 'light');
      }
    });
  }

  // Aplicar preferencia de modo oscuro al cargar
  if (localStorage.getItem('theme') === 'dark') {
    document.body.classList.add('dark');
  }

  // Ejemplo de alerta toast (puedes mejorar con Bootstrap Toasts)
  const addToCartBtns = document.querySelectorAll('.add-to-cart');
  addToCartBtns.forEach(btn => {
    btn.addEventListener('click', () => {
      alert("Producto agregado al carrito 🛒");
    });
  });
});