<footer class="bg-light text-center border-top mt-5">
  <div class="container py-3 d-flex justify-content-center">
    <p class="mb-0 text-muted text-center">
      © <?= date('Y') ?> Mercadoapp — Proyecto educativo estilo Mercado Libre.
    </p>
  </div>
</footer>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<script src="<?= BASE_URL ?>/assets/js/app.js"></script>


<script>
(() => {
   'use strict';
   const getStoredTheme = () => localStorage.getItem('theme');
   const setStoredTheme = theme => localStorage.setItem('theme', theme);
   const getPreferredTheme = () => {
       const storedTheme = getStoredTheme();
       if (storedTheme) return storedTheme;
       return window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
   };
   const setTheme = theme => {
       if (theme === 'auto') {
           document.documentElement.setAttribute('data-bs-theme',
             window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light');
       } else {
           document.documentElement.setAttribute('data-bs-theme', theme);
       }
   };
   setTheme(getPreferredTheme());
   document.querySelectorAll('[data-bs-theme-value]').forEach(toggle => {
       toggle.addEventListener('click', () => {
           const theme = toggle.getAttribute('data-bs-theme-value');
           setStoredTheme(theme);
           setTheme(theme);
       });
   });
})();
</script>

</body>
</html>
