<?php require_once __DIR__ . '/../config/config.php'; ?>

<nav class="navbar navbar-expand-lg navbar-primary bg-primary sticky-top shadow-sm">
  <div class="container">
    <a class="navbar-brand fw-bold text-white" href="<?= BASE_URL ?>/index.php">Mercadoapp</a>

    <button class="navbar-toggler bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#nav" aria-controls="nav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="nav">
      <form class="d-flex mx-auto w-50" role="search" action="<?= BASE_URL ?>/search.php" method="get">
        <input class="form-control me-2" type="search" name="q" placeholder="Buscar productos, marcas y más..." aria-label="Buscar" required>
        <button class="btn btn-light" type="submit">Buscar</button>
      </form>

      <ul class="navbar-nav ms-auto mb-2 mb-lg-0 align-items-lg-center">
        <?php if (!empty($_SESSION['user'])): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle text-white" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
              <?= htmlspecialchars($_SESSION['user']['name']) ?>
            </a>
            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
              <li><a class="dropdown-item" href="<?= BASE_URL ?>/orders.php"><i class="bi bi-cart4"></i> Mis compras</a></li>
              <li><a class="dropdown-item" href="<?= BASE_URL ?>/cart.php"><i class="bi bi-bag-fill"></i> Mi carrito</a></li>
              <li><a class="dropdown-item" href="<?= BASE_URL ?>/add_product.php"><i class="bi bi-archive-fill"></i> Subir producto</a></li>
              <li><a class="dropdown-item" href="<?= BASE_URL ?>/my_products.php"><i class="bi bi-inboxes-fill"></i> Mis productos</a></li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item" href="<?= BASE_URL ?>/profile.php"><i class="bi bi-gear-fill"></i> Configuración</a></li>

              <?php if ($_SESSION['user']['role'] === 'admin'): ?>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item fw-bold text-primary" href="<?= BASE_URL ?>/../admin/admin_panel.php"><i class="bi bi-gear-fill"></i> Panel Admin</a></li>
              <?php endif; ?>

              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item text-danger" href="<?= BASE_URL ?>/logout.php"><i class="bi bi-box-arrow-left"></i> Cerrar sesión</a></li>
            </ul>
          </li>
        <?php else: ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle text-white" href="#" id="guestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
              Cuenta
            </a>
            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="guestDropdown">
              <li><a class="dropdown-item" href="<?= BASE_URL ?>/login.php">🔑 Iniciar sesión</a></li>
              <li><a class="dropdown-item" href="<?= BASE_URL ?>/register.php">📝 Registrarse</a></li>
              <li><a class="dropdown-item" href="<?= BASE_URL ?>/cart.php"><i class="bi bi-bag-fill"></i> Mi carrito</a></li>
            </ul>
          </li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>
