<?php
session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';

// Solo usuarios logueados
if (empty($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

$success = $error = '';
$uploadedFiles = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $price = $_POST['price'] ?? 0;
    $category = trim($_POST['category'] ?? '');
    $currency = $_POST['currency'] ?? 'UYU'; // <- Nuevo

    if ($name && $price > 0 && $category) {
        // Insertar producto primero
        $stmt = $pdo->prepare("INSERT INTO products (name, description, price, category, currency, user_id) 
                               VALUES (:n, :d, :p, :c, :cur, :u) RETURNING id");
        $stmt->execute([
            ':n' => $name,
            ':d' => $description,
            ':p' => $price,
            ':c' => $category,
            ':cur' => $currency,
            ':u' => $_SESSION['user']['id']
        ]);
        $productId = $stmt->fetchColumn();

        // Procesar múltiples imágenes
        if (isset($_FILES['images'])) {
            $uploadDir = __DIR__ . '/../assets/img/';
            if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);

            foreach ($_FILES['images']['tmp_name'] as $key => $tmpName) {
                $fileName = $_FILES['images']['name'][$key];
                $fileType = $_FILES['images']['type'][$key];
                $fileError = $_FILES['images']['error'][$key];

                if ($fileError !== UPLOAD_ERR_OK) continue;

                $allowedTypes = ['image/jpeg','image/png','image/gif','image/webp'];
                if (!in_array($fileType, $allowedTypes)) continue;

                $newFileName = uniqid() . '-' . $fileName;
                $destPath = $uploadDir . $newFileName;

                if (move_uploaded_file($tmpName, $destPath)) {
                    $uploadedFiles[] = $newFileName;
                    $stmtImg = $pdo->prepare("INSERT INTO product_images (product_id, image) VALUES (:pid, :img)");
                    $stmtImg->execute([
                        ':pid' => $productId,
                        ':img' => $newFileName
                    ]);
                }
            }
        }

        $success = "✅ Producto publicado con éxito.";
    } else {
        $error = "⚠ Debes completar todos los campos obligatorios.";
    }
}
?>

<div class="container py-4">
  <h2>Subir un nuevo producto</h2>

  <?php if ($success): ?>
    <div class="alert alert-success"><?= $success ?></div>
  <?php endif; ?>
  <?php if ($error): ?>
    <div class="alert alert-danger"><?= $error ?></div>
  <?php endif; ?>

  <form method="post" enctype="multipart/form-data" class="row g-3" id="productForm">
    <div class="col-md-6">
      <label class="form-label">Nombre del producto *</label>
      <input type="text" name="name" class="form-control" required>
    </div>

    <div class="col-md-6">
      <label class="form-label">Categoría *</label>
      <input type="text" name="category" class="form-control" required>
    </div>

    <div class="col-md-12">
      <label class="form-label">Descripción</label>
      <textarea name="description" class="form-control"></textarea>
    </div>

<div class="col-md-4">
  <label class="form-label">Precio *</label>
  <input type="number" step="0.01" name="price" class="form-control" required>
</div>

<div class="col-md-4 d-flex align-items-end">
  <!-- Botón pequeño al lado del precio -->
  <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#currencyModal" style="height: 38px;">
    Elegir moneda
  </button>
</div>


    <div class="col-md-12">
      <label class="form-label">Imágenes del producto</label>
      <input type="file" name="images[]" class="form-control" accept="image/*" multiple>
      <small class="text-muted">Puedes subir varias imágenes. Solo se permiten archivos de imagen.</small>
    </div>

    <!-- Imágenes subidas -->
    <?php if($uploadedFiles): ?>
        <div class="col-12 mt-3">
            <h5>Imágenes subidas:</h5>
            <div class="d-flex flex-wrap gap-2">
                <?php foreach($uploadedFiles as $img): ?>
                    <img src="<?= BASE_URL . '/../assets/img/' . $img ?>" alt="" style="height:100px; border-radius:5px;">
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Campo oculto para moneda -->
    <input type="hidden" name="currency" id="currency" value="UYU">

    <div class="col-12">
      <button type="submit" class="btn btn-success">Publicar producto</button>
    </div>
  </form>
</div>

<!-- MODAL MONEDA -->
<div class="modal fade" id="currencyModal" tabindex="-1" aria-labelledby="currencyModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content shadow-lg">
      <div class="modal-header">
        <h5 class="modal-title" id="currencyModalLabel">Seleccionar Moneda</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body text-center">
        <p>Selecciona la moneda del producto:</p>
        <div class="btn-group" role="group">
          <input type="radio" class="btn-check" name="currencyOption" id="uyu" value="UYU" checked>
          <label class="btn btn-outline-primary" for="uyu">Pesos Uruguayos (UYU)</label>

          <input type="radio" class="btn-check" name="currencyOption" id="usd" value="USD">
          <label class="btn btn-outline-primary" for="usd">Dólares (USD)</label>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-success" id="saveCurrencyBtn">Guardar moneda</button>
      </div>
    </div>
  </div>
</div>

<script>
document.getElementById('saveCurrencyBtn').addEventListener('click', function() {
  const selected = document.querySelector('input[name="currencyOption"]:checked').value;
  document.getElementById('currency').value = selected;
  const modal = bootstrap.Modal.getInstance(document.getElementById('currencyModal'));
  modal.hide();
});
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
