<?php
session_start();
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';
require_once __DIR__ . '/../config/db.php';

// Solo admins
if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}

// Traer productos
$products = $pdo->query("SELECT p.*, c.name AS category FROM products p LEFT JOIN categories c ON c.id=p.category_id ORDER BY p.created_at DESC")->fetchAll();
?>

<div class="container my-4">
    <h1 class="h4 mb-4">Panel de administración</h1>
    
    <div class="mb-3">
        <a href="admin_add_product.php" class="btn btn-primary">Agregar producto</a>
    </div>

    <table class="table table-striped table-hover align-middle">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Categoría</th>
                <th>Precio</th>
                <th>Fecha creación</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($products as $p): ?>
                <tr>
                    <td><?= (int)$p['id'] ?></td>
                    <td><?= htmlspecialchars($p['name']) ?></td>
                    <td><?= htmlspecialchars($p['category'] ?? 'General') ?></td>
                    <td>$<?= number_format((float)$p['price'],2,',','.') ?></td>
                    <td><?= $p['created_at'] ?></td>
                    <td>
                        <a href="admin_edit_product.php?id=<?= (int)$p['id'] ?>" class="btn btn-sm btn-warning">Editar</a>
                        <a href="admin_delete_product.php?id=<?= (int)$p['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar producto?')">Eliminar</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
