<?php
session_start();
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';
require_once __DIR__ . '/../config/db.php';

// Solo admins
if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: ../public/login.php');
    exit;
}

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $desc = trim($_POST['description'] ?? '');
    $price = (float)($_POST['price'] ?? 0);
    $category_id = (int)($_POST['category_id'] ?? 0);
    $image = $_POST['image'] ?? '';

    if (!$name || $price <= 0) $errors[] = "Nombre y precio son obligatorios.";

    if (!$errors) {
        $stmt = $pdo->prepare("INSERT INTO products (name, description, price, category_id, image) 
                               VALUES (:name,:desc,:price,:cat,:img)");
        $stmt->execute([
            ':name'=>$name,
            ':desc'=>$desc,
            ':price'=>$price,
            ':cat'=>$category_id>0?$category_id:null,
            ':img'=>$image
        ]);
        header('Location: admin.php');
        exit;
    }
}

// Categorías para select
$categories = $pdo->query("SELECT id, name FROM categories ORDER BY name")->fetchAll();
?>

<div class="container my-4">
    <h1 class="h4 mb-3">Agregar Producto</h1>

    <?php foreach($errors as $err): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($err) ?></div>
    <?php endforeach; ?>

    <form method="post" class="w-50">
        <div class="mb-3">
            <label>Nombre</label>
            <input type="text" name="name" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Descripción</label>
            <textarea name="description" class="form-control"></textarea>
        </div>
        <div class="mb-3">
            <label>Precio</label>
            <input type="number" step="0.01" name="price" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Categoría</label>
            <select name="category_id" class="form-select">
                <option value="0">Sin categoría</option>
                <?php foreach ($categories as $c): ?>
                    <option value="<?= (int)$c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="mb-3">
            <label>Imagen (URL)</label>
            <input type="text" name="image" class="form-control">
        </div>
        <button class="btn btn-primary">Agregar</button>
    </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
