<?php
session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/header.php';

// Solo admins
if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: ../public/index.php");
    exit;
}

$stmt = $pdo->query("SELECT id, name, email, role, created_at FROM users ORDER BY created_at DESC");
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<body class="admin-page">
<?php require_once __DIR__ . '/../includes/navbar.php'; ?>

<div class="container py-4">
    <h2>👥 Gestión de Usuarios</h2>

    <table class="table table-striped mt-3">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Email</th>
                <th>Rol</th>
                <th>Creado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($users as $user): ?>
            <tr>
                <td><?= $user['id'] ?></td>
                <td><?= htmlspecialchars($user['name']) ?></td>
                <td><?= htmlspecialchars($user['email']) ?></td>
                <td><?= $user['role'] ?></td>
                <td><?= $user['created_at'] ?></td>
                <td>
                    <a href="edit_user.php?id=<?= $user['id'] ?>" class="btn btn-sm btn-outline-primary">✏️ Editar</a>
                    <a href="admin_users.php?delete=<?= $user['id'] ?>" onclick="return confirm('¿Eliminar usuario?')" class="btn btn-sm btn-outline-danger">🗑️ Eliminar</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
