<?php
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';
require_once __DIR__ . '/../config/db.php';

$cart = $_SESSION['cart'] ?? [];
$total = 0;
foreach ($cart as $item) { $total += $item['price']*$item['quantity']; }
?>

<div class="container my-4">
    <h1 class="h4 mb-4">Tu carrito</h1>
    <?php if (!$cart): ?>
        <div class="alert alert-info">Tu carrito está vacío.</div>
    <?php else: ?>
    <div class="table-responsive">
        <table class="table align-middle">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Precio</th>
                    <th>Cantidad</th>
                    <th>Subtotal</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($cart as $id=>$item): ?>
                <tr>
                    <td><?= htmlspecialchars($item['name']) ?></td>
                    <td>$<?= number_format($item['price'],2,',','.') ?></td>
                    <td><?= (int)$item['quantity'] ?></td>
                    <td>$<?= number_format($item['price']*$item['quantity'],2,',','.') ?></td>
                    <td><a href="../api/add_to_cart.php?action=remove&id=<?= $id ?>" class="btn btn-sm btn-danger">Eliminar</a></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="d-flex justify-content-between align-items-center mt-3">
        <h4>Total: $<?= number_format($total,2,',','.') ?></h4>
        <a href="checkout.php" class="btn btn-primary btn-lg">Ir a pagar</a>
    </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
