<?php
require __DIR__ . '/../vendor/autoload.php';

use MercadoPago\MercadoPagoConfig;
use MercadoPago\Client\Preference\PreferenceClient;

// 🔑 Access token de prueba
MercadoPagoConfig::setAccessToken("TEST-2055491541097382-100907-3ceedcf270457843d0a6b80dbd2b9971-2913045840");

// Crear cliente de preferencias
$client = new PreferenceClient();

// Ejemplo de productos del carrito (reemplazá con tus variables reales)
$items = [
    [
        "title" => "Skin AK-47 Redline",
        "quantity" => 1,
        "unit_price" => 25.00
    ],
    [
        "title" => "Skin M4A4 Howl",
        "quantity" => 1,
        "unit_price" => 70.00
    ]
];

// Crear preferencia
$preference = $client->create([
    "items" => $items,

    // 👉 Cuando el pago termina, Mercado Pago redirige a tu sistema
    "back_urls" => [
        "success" => "https://tusitio.com/orders.php?status=success",
        "failure" => "https://tusitio.com/orders.php?status=failure",
        "pending" => "https://tusitio.com/orders.php?status=pending"
    ],

    // Si el pago fue aprobado, vuelve automáticamente
    "auto_return" => "approved",

    // Datos adicionales (opcional)
    "metadata" => [
        "user_id" => 123, // o el ID del usuario logueado
        "cart_id" => 456
    ]
]);

// Redirigir al checkout de Mercado Pago
header("Location: " . $preference->init_point);
exit;
