<?php
// Solo iniciar sesión si no está iniciada
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/db.php'; // tu conexión $pdo
require_once __DIR__ . '/../includes/header.php';

$producto_id = $_GET['id'] ?? 0;

// Insertar comentario si se envió el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_SESSION['user'])) {
    $comentario = trim($_POST['comentario'] ?? '');
    $estrellas  = (int)($_POST['estrellas'] ?? 0);

    if ($comentario !== '' && $estrellas >= 1 && $estrellas <= 5) {
        $stmt = $pdo->prepare("
            INSERT INTO comentarios (producto_id, usuario_id, comentario, estrellas)
            VALUES (:producto_id, :usuario_id, :comentario, :estrellas)
        ");
        $stmt->execute([
            ':producto_id' => $producto_id,
            ':usuario_id'  => $_SESSION['user']['id'],
            ':comentario'  => $comentario,
            ':estrellas'   => $estrellas
        ]);
    }
}

// Cargar comentarios existentes
$stmt = $pdo->prepare("
    SELECT c.*, u.name as username 
    FROM comentarios c 
    JOIN users u ON c.usuario_id = u.id 
    WHERE c.producto_id = :producto_id 
    ORDER BY c.fecha DESC
");
$stmt->execute([':producto_id' => $producto_id]);
$reviews = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h2>Califica este producto</h2>

<?php if (isset($_SESSION['user'])): ?>
<div class="rating mb-3" id="ratingStars">
    <i class="bi bi-star" data-value="1"></i>
    <i class="bi bi-star" data-value="2"></i>
    <i class="bi bi-star" data-value="3"></i>
    <i class="bi bi-star" data-value="4"></i>
    <i class="bi bi-star" data-value="5"></i>
</div>

<p>Tu calificación: <span id="ratingValue">0</span> estrellas</p>

<form method="POST" id="reviewForm">
    <textarea name="comentario" id="comment" placeholder="Escribe tu opinión..." required></textarea>
    <input type="hidden" name="estrellas" id="hiddenStars" value="0">
    <button type="submit" class="btn btn-primary mt-2">Enviar reseña</button>
</form>
<?php else: ?>
<p>Debes <a href="login.php">iniciar sesión</a> para comentar.</p>
<?php endif; ?>

<div class="reviews mt-4">
    <h3>Reseñas:</h3>
    <?php foreach ($reviews as $r):
        $username = $r['username'];
        $rating   = $r['estrellas'];
        $comment  = $r['comentario'];
        $fecha    = $r['fecha'];
    ?>
        <div class="review card mb-3 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-2 flex-wrap">
                    <div class="author fw-bold"><?= htmlspecialchars($username) ?></div>
                    <div class="date text-muted small"><?= htmlspecialchars($fecha) ?></div>
                </div>
                <div class="stars mb-2" style="color:#f5c518; font-size:1.1rem;">
                    <?= str_repeat('★', $rating) . str_repeat('☆', 5 - $rating) ?> (<?= $rating ?>)
                </div>
                <p class="mb-0"><?= htmlspecialchars($comment) ?></p>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<style>
.review.card {
    border-left: 4px solid #007bff;
    border-radius: 8px;
}
.review.card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}
textarea#comment {
    width: 100%;
    min-height: 80px;
    padding: 10px;
    border-radius: 6px;
    border: 1px solid #ccc;
    font-size: 14px;
    resize: vertical;
}
.rating .bi {
    color: #ccc;
    font-size: 2.5rem;
    cursor: pointer;
    transition: color 0.2s, transform 0.2s;
}
.rating .bi.active { color: #f5c518; }
.rating .bi:hover { transform: scale(1.2); }
@media (max-width: 576px) {
    .review.card .d-flex.justify-content-between {
        flex-direction: column;
        align-items: flex-start;
        gap: 4px;
    }
}
</style>

<script>
const stars = document.querySelectorAll('#ratingStars .bi');
const ratingValue = document.getElementById('ratingValue');
const hiddenStars = document.getElementById('hiddenStars');
let currentRating = 0;

stars.forEach(star => {
    star.addEventListener('click', (e) => {
        const rect = star.getBoundingClientRect();
        const clickX = e.clientX - rect.left;
        const half = rect.width / 2;

        let value = parseInt(star.getAttribute('data-value'));
        currentRating = (clickX < half) ? value - 0.5 : value;

        updateStars(currentRating);
        ratingValue.textContent = currentRating;
        hiddenStars.value = currentRating;
    });

    star.addEventListener('mousemove', (e) => {
        const rect = star.getBoundingClientRect();
        const hoverX = e.clientX - rect.left;
        const half = rect.width / 2;

        let value = parseInt(star.getAttribute('data-value'));
        let hoverRating = (hoverX < half) ? value - 0.5 : value;

        updateStars(hoverRating);
    });

    star.addEventListener('mouseleave', () => {
        updateStars(currentRating);
    });
});

function updateStars(rating) {
    stars.forEach(star => {
        const value = parseInt(star.getAttribute('data-value'));
        star.classList.remove('bi-star', 'bi-star-fill', 'bi-star-half', 'active');

        if (rating >= value) {
            star.classList.add('bi-star-fill', 'active');
        } else if (rating + 0.5 === value) {
            star.classList.add('bi-star-half', 'active');
        } else {
            star.classList.add('bi-star');
        }
    });
}
</script>
