<?php
require_once __DIR__ . '/../config/db.php';
session_start();

if (empty($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];

// Calcular total (ejemplo)
$stmt = $pdo->prepare("SELECT SUM(quantity * price) as total FROM cart WHERE user_id = ?");
$stmt->execute([$user_id]);
$total = $stmt->fetchColumn();

if (!$total) {
    die("No hay productos en el carrito.");
}

// Crear orden local
$external_reference = 'ORDER_' . uniqid();
$stmt = $pdo->prepare("INSERT INTO orders (user_id, total, external_reference) VALUES (?, ?, ?)");
$stmt->execute([$user_id, $total, $external_reference]);

$order_id = $pdo->lastInsertId();

// Crear preferencia en MercadoPago
$access_token = "TEST-XXXXXXXXXXXXX"; // ← tu access token

$data = [
    "items" => [
        [
            "title" => "Compra en tu tienda",
            "quantity" => 1,
            "currency_id" => "UYU",
            "unit_price" => floatval($total)
        ]
    ],
    "external_reference" => $external_reference,
    "back_urls" => [
        "success" => "https://tusitio.com/pagos/callback.php",
        "failure" => "https://tusitio.com/pagos/callback.php",
        "pending" => "https://tusitio.com/pagos/callback.php"
    ],
    "auto_return" => "approved",
    "notification_url" => "https://tusitio.com/pagos/webhook.php"
];

$ch = curl_init("https://api.mercadopago.com/checkout/preferences");
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json",
    "Authorization: Bearer $access_token"
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$result = json_decode($response, true);

if (!empty($result['init_point'])) {
    header("Location: " . $result['init_point']);
    exit;
} else {
    echo "Error al crear preferencia: ";
    var_dump($result);
}
