<?php
session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../libs/phpmailer/src/PHPMailer.php';
require_once __DIR__ . '/../libs/phpmailer/src/SMTP.php';
require_once __DIR__ . '/../libs/phpmailer/src/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$message = '';
$step = 1;


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email'])) {
    $email = trim($_POST['email']);
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = :email");
    $stmt->execute([':email'=>$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        $code = rand(100000,999999);
        $_SESSION['reset_code'] = $code;
        $_SESSION['reset_user'] = $user['id'];
        $_SESSION['reset_email'] = $email;

        
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'mercadoapp03@gmail.com'; 
            $mail->Password = 'qjlz csct wfcg eztk'; 
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom('mercadoapp03@gmail.com', 'Mercadoapp');
            $mail->addAddress($email);
            $mail->isHTML(true);
            $mail->Subject = 'Código de recuperación';
            $mail->Body = "<p>Tu código temporal es: <b>$code</b></p>";

            $mail->send();
            $step = 2;
            $message = "✅ Se envió un código temporal a tu correo.";
        } catch (Exception $e) {
            $message = "❌ No se pudo enviar el correo: {$mail->ErrorInfo}";
            $step = 1;
        }
    } else {
        $message = "⚠️ No existe un usuario con ese correo.";
        $step = 1;
    }
}


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['code'])) {
    if (isset($_SESSION['reset_code']) && $_POST['code'] == $_SESSION['reset_code']) {
        $step = 3;
        $message = "✅ Código verificado, ahora puedes cambiar tu contraseña.";
    } else {
        $message = "❌ Código incorrecto.";
        $step = 2;
    }
}


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password']) && isset($_SESSION['reset_user'])) {
    $new_pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("UPDATE users SET password = :pass WHERE id = :id");
    $stmt->execute([':pass'=>$new_pass, ':id'=>$_SESSION['reset_user']]);
    unset($_SESSION['reset_code'], $_SESSION['reset_user'], $_SESSION['reset_email']);
    $message = "✅ Contraseña cambiada correctamente. Ahora puedes iniciar sesión.";
    $step = 4;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Recuperar contraseña</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body {
    background: linear-gradient(to right, #36d1dc, #5b86e5);
    font-family: 'Arial', sans-serif;
    height: 100vh;
}
.card {
    border-radius: 15px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.2);
}
.btn-primary {
    background-color: #3483fa;
    border: none;
}
.btn-primary:hover {
    background-color: #2968c8;
}
.icon-step {
    font-size: 40px;
    margin-bottom: 15px;
    color: #3483fa;
}
.alert-info {
    background-color: #e1f0ff;
    border-color: #b3daff;
    color: #055160;
}
</style>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
</head>
<body>
<div class="d-flex justify-content-center align-items-center h-100">
    <div class="card p-4 text-center" style="width: 100%; max-width: 420px;">
        <h3 class="mb-3" style="color:#3483fa;">Recuperar contraseña</h3>

        <?php if($message): ?>
            <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <?php if($step == 1): ?>
            <i class="bi bi-envelope icon-step"></i>
            <form method="post">
                <div class="mb-3">
                    <input type="email" class="form-control" name="email" placeholder="Tu correo electrónico" required>
                </div>
                <button class="btn btn-primary w-100">Enviar código</button>
            </form>

        <?php elseif($step == 2): ?>
            <i class="bi bi-key icon-step"></i>
            <form method="post">
                <div class="mb-3">
                    <input type="text" class="form-control" name="code" placeholder="Ingresa el código" required>
                </div>
                <button class="btn btn-primary w-100">Verificar código</button>
            </form>

        <?php elseif($step == 3): ?>
            <i class="bi bi-lock icon-step"></i>
            <form method="post">
                <div class="mb-3">
                    <input type="password" class="form-control" name="password" placeholder="Nueva contraseña" required>
                </div>
                <button class="btn btn-primary w-100">Cambiar contraseña</button>
            </form>

        <?php elseif($step == 4): ?>
            <i class="bi bi-check-circle icon-step"></i>
            <a href="login.php" class="btn btn-success w-100">Iniciar sesión</a>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
