<?php
require_once __DIR__ . '/../config/db.php';

// Datos del formulario
$name = $_POST['name'] ?? '';
$price = $_POST['price'] ?? 0;
$currency = $_POST['currency'] ?? 'UYU';
$description = $_POST['description'] ?? '';
$category_id = $_POST['category_id'] ?? null;

// Imagen principal
$image_url = null;
if (!empty($_FILES['image']['name'])) {
    $uploadDir = __DIR__ . '/../assets/img/';
    $fileName = time() . '_' . basename($_FILES['image']['name']);
    $targetPath = $uploadDir . $fileName;

    if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
        $image_url = $fileName;
    }
}

// Guardar en la base de datos
$stmt = $pdo->prepare("INSERT INTO products (name, price, currency, description, category_id, image_url)
                       VALUES (:name, :price, :currency, :description, :category_id, :image_url)");
$stmt->execute([
    ':name' => $name,
    ':price' => $price,
    ':currency' => $currency,
    ':description' => $description,
    ':category_id' => $category_id,
    ':image_url' => $image_url
]);

echo "<div class='container my-4 alert alert-success'>
✅ Producto guardado correctamente en $currency
</div>";
echo "<a href='add_product.php' class='btn btn-secondary ms-3'>Volver</a>";
