<?php
session_start();
require_once __DIR__ . '/../config/db.php';


if (!isset($_SESSION['user']) && isset($_COOKIE['login_token'])) {
    $token = $_COOKIE['login_token'];

    $stmt = $pdo->prepare("SELECT id, name, role FROM users WHERE token = :token LIMIT 1");
    $stmt->execute([':token' => $token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        $_SESSION['user'] = [
            'id' => $user['id'],
            'name' => $user['name'],
            'role' => strtolower($user['role'])
        ];
    } else {
        
        setcookie("login_token", "", time() - 3600, "/");
    }
}

require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';

$stmt = $pdo->query("SELECT p.*, u.name as seller 
                     FROM public.products p 
                     JOIN public.users u ON p.user_id = u.id 
                     ORDER BY p.created_at DESC 
                     LIMIT 12");

$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>



<div class="container py-5">
    <div class="bg-primary text-white rounded p-5 mb-4 text-center shadow-sm">
        <h1 class="display-5 fw-bold">Bienvenido a Mercadoapp</h1>
        <p class="lead">Compra y vende productos de manera rápida y segura</p>
        <a href="<?= BASE_URL ?>/add_product.php" class="btn btn-light btn-lg mt-3">
            <i class="bi bi-archive-fill"></i> Subí tu producto
        </a>
    </div>

    
    <div class="row mb-5 text-center">
        <?php 
        $categories = ['Electrónica','Ropa','Hogar','Juguetes','Deportes','Otros'];
        foreach($categories as $cat): ?>
            <div class="col-md-2 col-4 mb-3">
                <a href="<?= BASE_URL ?>/search.php?q=<?= urlencode($cat) ?>" class="btn btn-outline-primary w-100"><?= $cat ?></a>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="row">
    <?php if($products): ?>
        <?php foreach($products as $prod): ?>
            <?php
            $stmtImgs = $pdo->prepare("SELECT image FROM product_images WHERE product_id = :pid ORDER BY id ASC");
            $stmtImgs->execute([':pid' => $prod['id']]);
            $images = $stmtImgs->fetchAll(PDO::FETCH_COLUMN);

            if (!$images) {
                $images[] = $prod['image_url'] ?: 'https://picsum.photos/seed/noimg/300/200';
            }

            $mainImage = $images[0];
            $thumbs = $images;
            ?>
            <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                <div class="card h-100 shadow-sm border-0">
                    <img src="<?= BASE_URL . '/../assets/img/' . $mainImage ?>" 
                         class="card-img-top main-image" 
                         style="height:200px;object-fit:cover;" 
                         alt="<?= htmlspecialchars($prod['name']) ?>">

                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title"><?= htmlspecialchars($prod['name']) ?></h5>
                        <p class="card-text text-truncate"><?= htmlspecialchars($prod['description']) ?></p>
                        <p class="fw-bold text-primary mb-2">$<?= number_format($prod['price'],2) ?></p>
                        <p class="text-muted mb-2" style="font-size:0.8rem;">Vendido por <?= htmlspecialchars($prod['seller']) ?></p>
                        
                        <div class="d-flex flex-wrap gap-1 mb-2">
                            <?php foreach($thumbs as $img): ?>
                                <img src="<?= BASE_URL . '/../assets/img/' . $img ?>" 
                                     class="img-thumbnail thumb" 
                                     style="width:50px;height:50px;object-fit:cover;cursor:pointer;">
                            <?php endforeach; ?>
                        </div>

                        <a href="<?= BASE_URL ?>/product.php?id=<?= $prod['id'] ?>" class="btn btn-primary mt-auto">Ver detalle</a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p class="text-center text-muted">No hay productos disponibles.</p>
    <?php endif; ?>
</div>

<script>
document.querySelectorAll('.card').forEach(card => {
    const mainImage = card.querySelector('.main-image');
    card.querySelectorAll('.thumb').forEach(thumb => {
        thumb.addEventListener('click', () => {
            mainImage.src = thumb.src;
        });
    });
});
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
