<?php
session_start();
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';

$errors = [];


if (isset($_SESSION['user'])) {
    if (strtolower($_SESSION['user']['role']) === 'admin') {
        header('Location: ../admin/admin_panel.php');
        exit;
    } else {
        header('Location: ../index.php');
        exit;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    // Buscar usuario en la base de datos
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email LIMIT 1");
    $stmt->execute([':email' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        // Si el rol está vacío, asignar 'user' por defecto
        $role = $user['role'] ?: 'user';

        // Actualizar la base de datos si estaba vacío
        if (!$user['role']) {
            $updateStmt = $pdo->prepare("UPDATE users SET role = :role WHERE id = :id");
            $updateStmt->execute([':role' => $role, ':id' => $user['id']]);
        }

        // ✅ Guardar sesión correctamente
        $_SESSION['user'] = [
            'id' => $user['id'],
            'name' => $user['name'],
            'role' => strtolower($role)
        ];

        // ✅ Crear cookie para login persistente
        $token = bin2hex(random_bytes(16));
        setcookie("login_token", $token, [
            'expires' => time() + 86400*7, // 7 días
            'path' => '/',
            'secure' => isset($_SERVER['HTTPS']),
            'httponly' => true,
            'samesite' => 'Strict'
        ]);

        // Guardar token en la base de datos
        $stmtToken = $pdo->prepare("UPDATE users SET token = :token WHERE id = :id");
        $stmtToken->execute([':token' => $token, ':id' => $user['id']]);

        // ✅ Redirigir según rol
        if ($_SESSION['user']['role'] === 'admin') {
            header('Location: ../admin/admin_panel.php');
        } else {
            header('Location: ../index.php');
        }
        exit;

    } else {
        $errors[] = "Email o contraseña incorrectos.";
    }
}
?>

<div class="container my-4">
    <h1 class="h4 mb-3">Ingresar</h1>

    <?php foreach ($errors as $err): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($err) ?></div>
    <?php endforeach; ?>

    <form method="post" class="w-50">
        <div class="mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Contraseña</label>
            <input type="password" name="password" class="form-control" required>
        </div>
        <a href="forgot.php">¿Olvidaste tu contraseña?</a><br>
        <button class="btn btn-primary">Ingresar</button>
    </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
