<?php
session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';

if (empty($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];

// Eliminar producto
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM products WHERE id = :id AND user_id = :uid");
    $stmt->execute([':id' => $id, ':uid' => $user_id]);
    header("Location: my_products.php?msg=deleted");
    exit;
}

// Actualizar producto
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_id'])) {
    $id = (int) $_POST['edit_id'];
    $name = trim($_POST['name']);
    $price = (float) $_POST['price'];
    $description = trim($_POST['description']);
    $category = trim($_POST['category']);

    $stmt = $pdo->prepare("UPDATE products 
        SET name = :n, price = :p, description = :d, category = :c 
        WHERE id = :id AND user_id = :uid");
    $stmt->execute([
        ':n' => $name,
        ':p' => $price,
        ':d' => $description,
        ':c' => $category,
        ':id' => $id,
        ':uid' => $user_id
    ]);

    header("Location: my_products.php?msg=updated");
    exit;
}

// Traer productos del usuario
$stmt = $pdo->prepare("SELECT * FROM products WHERE user_id = :uid ORDER BY created_at DESC");
$stmt->execute([':uid' => $user_id]);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container py-4">
  <h2>📑 Mis productos publicados</h2>

  <?php if (isset($_GET['msg'])): ?>
      <div class="alert alert-success">
        <?= $_GET['msg'] === 'deleted' ? '✅ Producto eliminado.' : '✅ Producto actualizado.' ?>
      </div>
  <?php endif; ?>

  <?php if (!$products): ?>
    <div class="alert alert-info">⚠️ Aún no has publicado productos.</div>
  <?php else: ?>
    <div class="row">
      <?php foreach ($products as $p): ?>
        <?php
        // Obtener todas las imágenes del producto
        $stmtImgs = $pdo->prepare("SELECT image FROM product_images WHERE product_id = :pid");
        $stmtImgs->execute([':pid' => $p['id']]);
        $images = $stmtImgs->fetchAll(PDO::FETCH_COLUMN);

        // Si no hay imágenes, usar una por defecto
        if (!$images) {
            $images[] = 'https://picsum.photos/seed/noimg/300/200';
        }

        $mainImage = $images[0];
        ?>
        <div class="col-md-4">
          <div class="card mb-4 shadow-sm">
            <!-- Imagen principal -->
            <img src="<?= BASE_URL . '/../assets/img/' . $mainImage ?>" 
                 class="card-img-top main-image" 
                 style="height:200px;object-fit:cover;">

            <div class="card-body">
              <h5 class="card-title"><?= htmlspecialchars($p['name']) ?></h5>
              <p class="card-text text-muted"><?= htmlspecialchars($p['category']) ?></p>
              <p class="card-text">$<?= number_format($p['price'], 2) ?></p>

              <!-- Descripción recortada -->
              <?php 
                $desc = htmlspecialchars($p['description']);
                $short = mb_strimwidth($desc, 0, 80, '...');
              ?>
              <p class="card-text small description-short"><?= $short ?></p>
              <p class="card-text small description-full d-none"><?= $desc ?></p>
              <?php if(strlen($desc) > 80): ?>
                <button class="btn btn-link btn-sm toggle-desc">Ver más</button>
              <?php endif; ?>

              <!-- Miniaturas -->
              <div class="d-flex flex-wrap gap-1 mb-2 mt-2">
                <?php foreach($images as $img): ?>
                  <img src="<?= BASE_URL . '/../assets/img/' . $img ?>" 
                       class="img-thumbnail thumb" 
                       style="width:50px;height:50px;object-fit:cover;cursor:pointer;">
                <?php endforeach; ?>
              </div>

              <!-- Botones -->
              <a href="?delete=<?= $p['id'] ?>" class="btn btn-danger btn-sm"
                 onclick="return confirm('¿Seguro que quieres eliminar este producto?')">Eliminar</a>
              <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editModal<?= $p['id'] ?>">Editar</button>
            </div>
          </div>
        </div>

        <!-- Modal de edición -->
        <div class="modal fade" id="editModal<?= $p['id'] ?>" tabindex="-1">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <form method="post">
                <div class="modal-header">
                  <h5 class="modal-title">Editar producto</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body row g-3">
                  <input type="hidden" name="edit_id" value="<?= $p['id'] ?>">

                  <div class="col-md-6">
                    <label class="form-label">Nombre</label>
                    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($p['name']) ?>" required>
                  </div>

                  <div class="col-md-6">
                    <label class="form-label">Categoría</label>
                    <input type="text" name="category" class="form-control" value="<?= htmlspecialchars($p['category']) ?>" required>
                  </div>

                  <div class="col-md-12">
                    <label class="form-label">Descripción</label>
                    <textarea name="description" class="form-control"><?= htmlspecialchars($p['description']) ?></textarea>
                  </div>

                  <div class="col-md-4">
                    <label class="form-label">Precio</label>
                    <input type="number" step="0.01" name="price" class="form-control" value="<?= $p['price'] ?>" required>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="submit" class="btn btn-primary">Guardar cambios</button>
                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
              </form>
            </div>
          </div>
        </div>

      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>

<script>
// Cambiar imagen principal al clickear miniaturas y mostrar/ocultar descripción
document.querySelectorAll('.card').forEach(card => {
    // Miniaturas
    const mainImage = card.querySelector('.main-image');
    card.querySelectorAll('.thumb').forEach(thumb => {
        thumb.addEventListener('click', () => {
            mainImage.src = thumb.src;
        });
    });

    // Descripción
    const btn = card.querySelector('.toggle-desc');
    if(btn){
        btn.addEventListener('click', () => {
            card.querySelector('.description-short').classList.toggle('d-none');
            card.querySelector('.description-full').classList.toggle('d-none');
            btn.textContent = btn.textContent === 'Ver más' ? 'Ver menos' : 'Ver más';
        });
    }
});
</script>
