<?php
session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';

if (empty($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

$userId = $_SESSION['user']['id'];
$stmt = $pdo->prepare("SELECT * FROM orders WHERE user_id = :uid ORDER BY created_at DESC");
$stmt->execute([':uid' => $userId]);
$orders = $stmt->fetchAll();
?>
<div class="container py-4">
  <h2>Mis Compras</h2>

  <?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success">¡Compra realizada con éxito! 🎉</div>
  <?php endif; ?>

  <?php if (empty($orders)): ?>
    <p>No tenés compras registradas.</p>
  <?php else: ?>
    <div class="accordion" id="ordersAccordion">
      <?php foreach ($orders as $i => $order): ?>
        <div class="accordion-item">
          <h2 class="accordion-header" id="heading<?= $i ?>">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?= $i ?>">
              Orden #<?= $order['id'] ?> - $<?= number_format($order['total'], 2) ?> - <?= $order['created_at'] ?>
            </button>
          </h2>
          <div id="collapse<?= $i ?>" class="accordion-collapse collapse" data-bs-parent="#ordersAccordion">
            <div class="accordion-body">
              <p><strong>Dirección:</strong> <?= htmlspecialchars($order['address']) ?></p>
              <p><strong>Método de pago:</strong> <?= htmlspecialchars($order['payment_method']) ?></p>
              <h6>Productos:</h6>
              <ul>
                <?php
                $stmtItems = $pdo->prepare("SELECT oi.*, p.name FROM order_items oi JOIN products p ON oi.product_id = p.id WHERE oi.order_id = :oid");
                $stmtItems->execute([':oid' => $order['id']]);
                $items = $stmtItems->fetchAll();
                foreach ($items as $item):
                ?>
                  <li><?= $item['name'] ?> (x<?= $item['quantity'] ?>) - $<?= number_format($item['price'] * $item['quantity'], 2) ?></li>
                <?php endforeach; ?>
              </ul>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
