<?php
session_start();
require_once __DIR__ . '/../config/db.php';
require __DIR__ . '/vendor/autoload.php';

use MercadoPago\MercadoPagoConfig;
use MercadoPago\Client\Payment\PaymentClient;

MercadoPagoConfig::setAccessToken("TEST-2055491541097382-100907-3ceedcf270457843d0a6b80dbd2b9971-2913045840");

$status = $_GET['status'] ?? null;
$paymentId = $_GET['payment_id'] ?? null;

if ($status === 'success' && $paymentId) {
    $client = new PaymentClient();
    $payment = $client->get($paymentId);

    if ($payment->status === 'approved') {
        $userId = $_SESSION['user']['id'];
        $total = $payment->transaction_amount;
        $paymentMethod = $payment->payment_method_id;
        $address = $_SESSION['checkout_address'] ?? 'No especificada';

        // Guardar orden en base de datos
        $stmt = $pdo->prepare("INSERT INTO orders (user_id, total, address, payment_method, created_at) 
                               VALUES (:uid, :total, :addr, :pm, NOW())");
        $stmt->execute([
            ':uid' => $userId,
            ':total' => $total,
            ':addr' => $address,
            ':pm' => $paymentMethod
        ]);
        $orderId = $pdo->lastInsertId();

        // Guardar productos del carrito
        $cart = $_SESSION['cart'] ?? [];
        foreach ($cart as $product) {
            $stmtItem = $pdo->prepare("INSERT INTO order_items (order_id, product_id, quantity, price)
                                       VALUES (:oid, :pid, :qty, :price)");
            $stmtItem->execute([
                ':oid' => $orderId,
                ':pid' => $product['id'],
                ':qty' => $product['quantity'],
                ':price' => $product['price']
            ]);
        }

        // Vaciar carrito
        unset($_SESSION['cart']);

        // Redirigir a orders.php con mensaje de éxito
        header("Location: orders.php?success=1");
        exit;
    }
}

// Si falla o es pendiente
header("Location: orders.php");
exit;
