<?php
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';
require_once __DIR__ . '/../config/db.php';

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT p.*, c.name AS category FROM products p LEFT JOIN categories c ON c.id=p.category_id WHERE p.id=:id");
$stmt->execute([':id'=>$id]);
$p = $stmt->fetch();

if (!$p) {
    echo "<div class='container my-4'><div class='alert alert-danger'>Producto no encontrado</div></div>";
    require_once __DIR__ . '/../includes/footer.php';
    exit;
}


$stmtImgs = $pdo->prepare("SELECT image FROM product_images WHERE product_id = :pid");
$stmtImgs->execute([':pid' => $p['id']]);
$images = $stmtImgs->fetchAll(PDO::FETCH_COLUMN);


if (!$images) {
    $images[] = $p['image_url'] ?: 'https://picsum.photos/seed/noimg/600/400';
}

$mainImage = $images[0];
$shortDesc = strlen($p['description']) > 150 ? substr($p['description'], 0, 150) . '...' : $p['description'];
?>

<div class="container my-4 main">
    <style>
        .hover\:main {
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
    </style>
    <div class="row">
       
        <div class="col-md-5">
            <img src="<?= BASE_URL . '/../assets/img/' . $mainImage ?>" 
                 class="img-fluid rounded mb-2 main-image" 
                 alt="<?= htmlspecialchars($p['name']) ?>" 
                 style="width:100%; height:400px; object-fit:cover;">

            <div class="d-flex flex-wrap gap-1 mb-2">
                <?php foreach($images as $img): ?>
                    <img src="<?= BASE_URL . '/../assets/img/' . $img ?>" 
                         class="img-thumbnail thumb" 
                         style="width:60px; height:60px; object-fit:cover; cursor:pointer;">
                <?php endforeach; ?>
            </div>
        </div>

        
        <div class="col-md-7">
            <h1 class="h4"><?= htmlspecialchars($p['name']) ?></h1>
            <p class="text-muted"><?= htmlspecialchars($p['category'] ?? 'General') ?></p>
            <p class="h5">$ <?= number_format((float)$p['price'],2,',','.') ?></p>

            <p id="desc-short"><?= nl2br(htmlspecialchars($shortDesc)) ?></p>
            <?php if(strlen($p['description']) > 150): ?>
                <p id="desc-full" class="d-none"><?= nl2br(htmlspecialchars($p['description'])) ?></p>
                <button id="toggleDesc" class="btn btn-link p-0">Ver más</button>
            <?php endif; ?><br>

            
            <form action="../api/add_to_cart.php" method="GET" class="d-flex align-items-center gap-2 mt-2">
                <input type="hidden" name="action" value="add">
                <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">

                <div class="input-group" style="width:120px;">
                    <button type="button" class="btn btn-outline-secondary" id="qtyMinus">-</button>
                    <input type="text" name="quantity" id="qtyInput" value="1" class="form-control text-center" readonly>
                    <button type="button" class="btn btn-outline-secondary" id="qtyPlus">+</button>
                </div>

                <button type="submit" class="btn btn-primary">Agregar al carrito</button>
            </form>
        </div>
    </div>
</div>

<?php 
$producto_id = $p['id'];
include __DIR__ . '/comentarios.php';
?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>

<script>

const mainImage = document.querySelector('.main-image');
document.querySelectorAll('.thumb').forEach(thumb => {
    thumb.addEventListener('click', () => {
        mainImage.src = thumb.src;
    });
});


const toggleBtn = document.getElementById('toggleDesc');
if(toggleBtn){
    toggleBtn.addEventListener('click', () => {
        document.getElementById('desc-short').classList.toggle('d-none');
        document.getElementById('desc-full').classList.toggle('d-none');
        toggleBtn.textContent = toggleBtn.textContent === 'Ver más' ? 'Ver menos' : 'Ver más';
    });
}


const qtyInput = document.getElementById('qtyInput');
document.getElementById('qtyPlus').addEventListener('click', () => {
    qtyInput.value = parseInt(qtyInput.value) + 1;
});
document.getElementById('qtyMinus').addEventListener('click', () => {
    qtyInput.value = Math.max(1, parseInt(qtyInput.value) - 1);
});
</script>
