<?php
session_start();
if (isset($_COOKIE['dark_mode'])) {
    $_SESSION['user']['dark_mode'] = $_COOKIE['dark_mode'];
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';

if (empty($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}



$success = $error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $current_password = $_POST['current_password'] ?? '';
    $new_password = $_POST['password'] ?? '';
    $dark_mode = isset($_POST['dark_mode']) ? 1 : 0;

    if ($name && $email) {
        try {
            $stmt = $pdo->prepare("SELECT password FROM users WHERE id=:id");
            $stmt->execute([':id' => $_SESSION['user']['id']]);
            $stored = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($new_password) {
                if (!$current_password || !password_verify($current_password, $stored['password'])) {
                    $error = "⚠ Contraseña actual incorrecta.";
                } else {
                    $stmt = $pdo->prepare("UPDATE users SET name=:name, email=:email, password=:pass, dark_mode=:dm WHERE id=:id");
                    $stmt->execute([
                        ':name'=>$name, 
                        ':email'=>$email, 
                        ':pass'=>password_hash($new_password,PASSWORD_DEFAULT),
                        ':dm'=>$dark_mode, 
                        ':id'=>$_SESSION['user']['id']
                    ]);
                    $_SESSION['user']['name'] = $name;
                    $_SESSION['user']['email'] = $email;
                    $_SESSION['user']['dark_mode'] = $dark_mode;
                    setcookie('dark_mode', $dark_mode, time() + (30 * 24 * 60 * 60), "/");
                    $success = "✅ Perfil actualizado con éxito.";
                }
            } else {
                $stmt = $pdo->prepare("UPDATE users SET name=:name, email=:email, dark_mode=:dm WHERE id=:id");
                $stmt->execute([
                    ':name'=>$name, 
                    ':email'=>$email, 
                    ':dm'=>$dark_mode, 
                    ':id'=>$_SESSION['user']['id']
                ]);
                $_SESSION['user']['name'] = $name;
                $_SESSION['user']['email'] = $email;
                $_SESSION['user']['dark_mode'] = $dark_mode;
                $success = "✅ Perfil actualizado con éxito.";
            }
        } catch (PDOException $e) {
            $error = "Error al actualizar: " . $e->getMessage();
        }
    } else {
        $error = "⚠ Nombre y email son obligatorios.";
    }
}

$user = $_SESSION['user'];
?>

<div class="container py-4">
  <h2><i class="bi bi-gear-fill"></i> Configuración de perfil</h2>

  <?php if($success): ?>
    <div class="alert alert-success"><?= $success ?></div>
  <?php endif; ?>
  <?php if($error): ?>
    <div class="alert alert-danger"><?= $error ?></div>
  <?php endif; ?>

  <form method="post" class="row g-3">
    <div class="col-12">
      <label class="form-label">Nombre *</label>
      <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($user['name'] ?? '') ?>" required>
    </div>

    <div class="col-12">
      <label class="form-label">Email *</label>
      <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email'] ?? '') ?>" required>
    </div>

    <div class="col-12">
      <label class="form-label">Contraseña actual</label>
      <input type="password" name="current_password" class="form-control">
    </div>

    <div class="col-12">
      <label class="form-label">Nueva contraseña (dejar vacío para no cambiar)</label>
      <input type="password" name="password" class="form-control">
    </div>

    <div class="col-12 form-check mt-3">
      <input class="form-check-input" type="checkbox" name="dark_mode" id="darkMode" <?= !empty($user['dark_mode'] ?? 0) ? 'checked' : '' ?>>
      <label class="form-check-label" for="darkMode">Modo oscuro</label>
    </div>

    <div class="col-12">
      <button type="submit" class="btn btn-primary mt-3">Guardar cambios</button>
    </div>
  </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
