<?php
session_start();
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm'] ?? '';

    if ($password !== $confirm) $errors[] = "Las contraseñas no coinciden.";
    if (!$errors) {
        $hash = password_hash($password, PASSWORD_BCRYPT);
        try {
            $stmt = $pdo->prepare("INSERT INTO users (name,email,password) VALUES (:name,:email,:password)");
            $stmt->execute([':name'=>$name, ':email'=>$email, ':password'=>$hash]);
            $_SESSION['user'] = ['id'=>$pdo->lastInsertId(), 'name'=>$name, 'role'=>'user'];
            header('Location: index.php');
            exit;
        } catch (PDOException $e) {
            if (strpos($e->getMessage(),'duplicate key') !== false) {
                $errors[] = "El email ya está registrado.";
            } else {
                $errors[] = "Error al registrar: " . $e->getMessage();
            }
        }
    }
}
?>

<div class="container my-4">
    <h1 class="h4 mb-3">Crear cuenta</h1>
    <?php foreach($errors as $err): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($err) ?></div>
    <?php endforeach; ?>
    <form method="post" class="w-50">
        <div class="mb-3">
            <label>Nombre</label>
            <input type="text" name="name" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Contraseña</label>
            <input type="password" name="password" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Confirmar contraseña</label>
            <input type="password" name="confirm" class="form-control" required>
        </div>
        <button class="btn btn-primary">Registrarse</button>
    </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
