<?php
session_start();
require_once __DIR__ . '/../config/db.php';

// Solo permitir acceso si el usuario pasó la verificación de código
if (empty($_SESSION['reset_user_id']) || empty($_SESSION['allow_reset'])) {
    header("Location: forgot.php");
    exit;
}

$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = trim($_POST['password'] ?? '');
    $confirm  = trim($_POST['confirm'] ?? '');

    if ($password === '' || $confirm === '') {
        $error = "Todos los campos son obligatorios.";
    } elseif ($password !== $confirm) {
        $error = "Las contraseñas no coinciden.";
    } else {
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        $user_id = $_SESSION['reset_user_id'];

        // Actualizar contraseña
        $stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
        $stmt->execute([$hashed, $user_id]);

        // Limpiar registros de reseteo
        $stmt = $pdo->prepare("DELETE FROM password_resets WHERE user_id = ?");
        $stmt->execute([$user_id]);

        // Limpiar sesión de reset
        session_unset();
        session_destroy();

        $success = true;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Restablecer contraseña</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', sans-serif;
        }
        .card {
            border-radius: 15px;
            padding: 30px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.2);
            background: #fff;
        }
        .btn-primary:hover {
            background-color: #2968c8;
        }
        h3 {
            color: #3483fa;
        }
    </style>
</head>
<body>
<div class="card text-center">
    <?php if ($success): ?>
        <h3>¡Contraseña cambiada!</h3>
        <p>Tu nueva contraseña ha sido guardada correctamente.</p>
        <a href="login.php" class="btn btn-primary w-100">Iniciar sesión</a>
    <?php else: ?>
        <h3>Restablecer contraseña</h3>
        <?php if ($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <form method="POST" class="mt-3 text-start">
            <div class="mb-3">
                <label for="password" class="form-label">Nueva contraseña</label>
                <input type="password" name="password" id="password" class="form-control" required minlength="6">
            </div>
            <div class="mb-3">
                <label for="confirm" class="form-label">Confirmar contraseña</label>
                <input type="password" name="confirm" id="confirm" class="form-control" required minlength="6">
            </div>
            <button type="submit" class="btn btn-primary w-100">Guardar contraseña</button>
        </form>
        <div class="mt-3 text-center">
            <a href="login.php" style="color:#3483fa;">Volver al inicio de sesión</a>
        </div>
    <?php endif; ?>
</div>
</body>
</html>
