<?php
session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/navbar.php';


$cats = $pdo->query("SELECT id, name FROM categories WHERE name <> '' ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);


$category = trim($_GET['category'] ?? '');
$minPrice = $_GET['minPrice'] ?? '';
$maxPrice = $_GET['maxPrice'] ?? '';
$order = $_GET['order'] ?? '';


$sql = "SELECT p.*, c.name AS category_name 
        FROM products p
        LEFT JOIN categories c ON p.category_id = c.id
        WHERE 1=1";
$params = [];


if (!empty($category)) {
    $sql .= " AND c.name ILIKE :cat";
    $params[':cat'] = $category;
}


if ($minPrice !== '') {
    $sql .= " AND p.price >= :min";
    $params[':min'] = (float)$minPrice;
}
if ($maxPrice !== '') {
    $sql .= " AND p.price <= :max";
    $params[':max'] = (float)$maxPrice;
}


switch ($order) {
    case "price_asc":
        $sql .= " ORDER BY p.price ASC";
        break;
    case "price_desc":
        $sql .= " ORDER BY p.price DESC";
        break;
    default:
        $sql .= " ORDER BY p.created_at DESC";
        break;
}


$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container py-4">
  <h2>Productos</h2>

  
  <form method="get" class="row g-3 mb-4" id="filterForm">
    <div class="col-md-3">
      <label class="form-label">Categoría</label>
      <select class="form-select" name="category" id="categorySelect">
        <option value="">Todas</option>
        <?php foreach ($cats as $c): ?>
          <option value="<?= htmlspecialchars($c['name']) ?>" <?= $c['name'] === $category ? 'selected' : '' ?>>
            <?= htmlspecialchars($c['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-2">
      <label class="form-label">Precio mínimo</label>
      <input type="number" step="0.01" class="form-control" name="minPrice" value="<?= htmlspecialchars($minPrice) ?>">
    </div>

    <div class="col-md-2">
      <label class="form-label">Precio máximo</label>
      <input type="number" step="0.01" class="form-control" name="maxPrice" value="<?= htmlspecialchars($maxPrice) ?>">
    </div>

    <div class="col-md-2">
      <label class="form-label">Ordenar por</label>
      <select class="form-select" name="order">
        <option value="">Más recientes</option>
        <option value="price_asc" <?= $order==='price_asc'?'selected':'' ?>>Precio: menor a mayor</option>
        <option value="price_desc" <?= $order==='price_desc'?'selected':'' ?>>Precio: mayor a menor</option>
      </select>
    </div>

    <div class="col-md-1 d-flex align-items-end">
      <button type="submit" class="btn btn-primary w-100">Filtrar</button>
    </div>
  </form>


  <?php if (empty($results)): ?>
    <p>No se encontraron productos.</p>
  <?php else: ?>
    <div class="row">
      <?php foreach ($results as $product): ?>
        <?php
       
        $stmtImgs = $pdo->prepare("SELECT image FROM product_images WHERE product_id = :pid ORDER BY id ASC");
        $stmtImgs->execute([':pid' => $product['id']]);
        $images = $stmtImgs->fetchAll(PDO::FETCH_COLUMN);

        if (!$images) {
            $images[] = $product['image_url'] ?: 'https://picsum.photos/seed/noimg/300/200';
        }

        $mainImage = $images[0];
        ?>
        <div class="col-md-3 mb-4">
          <div class="card h-100">
            <img src="<?= BASE_URL . '/../assets/img/' . $mainImage ?>" class="card-img-top main-image" alt="<?= htmlspecialchars($product['name']) ?>" style="height:200px;object-fit:cover;">
            <div class="card-body d-flex flex-column">
              <h5 class="card-title"><?= htmlspecialchars($product['name']) ?></h5>
              <p class="card-text text-truncate"><?= htmlspecialchars($product['description']) ?></p>
              <p class="fw-bold text-primary mb-2">$<?= number_format($product['price'], 2) ?></p>
              <p class="text-muted mb-2" style="font-size:0.8rem;">Categoría: <?= htmlspecialchars($product['category_name'] ?? 'Sin categoría') ?></p>

              <div class="d-flex flex-wrap gap-1 mb-2">
                <?php foreach($images as $img): ?>
                  <img src="<?= BASE_URL . '/../assets/img/' . $img ?>" class="img-thumbnail thumb" style="width:50px;height:50px;object-fit:cover;cursor:pointer;">
                <?php endforeach; ?>
              </div>

              <a href="product.php?id=<?= $product['id'] ?>" class="btn btn-primary mt-auto w-100">Ver producto</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>

<script>

document.querySelectorAll('.card').forEach(card => {
    const mainImage = card.querySelector('.main-image');
    card.querySelectorAll('.thumb').forEach(thumb => {
        thumb.addEventListener('click', () => {
            mainImage.src = thumb.src;
        });
    });
});


document.getElementById('categorySelect').addEventListener('change', () => {
    document.getElementById('filterForm').submit();
});
</script>
