<?php
session_start();
require_once __DIR__ . '/../config/db.php';

if (empty($_SESSION['reset_user_id'])) {
    header("Location: forgot.php");
    exit;
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = trim($_POST['code']);
    $user_id = $_SESSION['reset_user_id'];

    $stmt = $pdo->prepare("SELECT * FROM password_resets WHERE user_id = ? AND code = ? AND expires_at > NOW()");
    $stmt->execute([$user_id, $code]);
    $reset = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($reset) {
        $_SESSION['allow_reset'] = true;
        header("Location: reset.php");
        exit;
    } else {
        $message = "❌ Código inválido o vencido.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Verificar código</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex justify-content-center align-items-center vh-100">
    <div class="card shadow p-4" style="max-width: 400px; width:100%;">
        <h3 class="text-center mb-3">Verificar código</h3>
        <?php if ($message): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="mb-3">
                <label for="code" class="form-label">Código de 6 dígitos</label>
                <input type="text" name="code" id="code" class="form-control" required maxlength="6">
            </div>
            <button type="submit" class="btn btn-success w-100">Verificar</button>
        </form>
    </div>
</body>
</html>
