<?php
require_once __DIR__ . '/../config/db.php';

$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!isset($data['data']['id'])) {
    http_response_code(400);
    exit;
}

$payment_id = $data['data']['id'];

$access_token = "TEST-XXXXXXXXXXXXX";
$ch = curl_init("https://api.mercadopago.com/v1/payments/$payment_id");
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $access_token"
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$payment = json_decode($response, true);

if (!empty($payment['external_reference'])) {
    $stmt = $pdo->prepare("
        UPDATE orders 
        SET payment_status = ?, confirmed_at = NOW()
        WHERE external_reference = ?
    ");
    $stmt->execute([$payment['status'], $payment['external_reference']]);
}

http_response_code(200);
